<?php

// Creamos una notificacion con nuestro botón
add_action("admin_notices", function() {
  echo "<div><p>Agregar nuevo contenido. "
    . "<a class='button href='{$_SERVER["REQUEST_URI"]}&rj_nuevos'>"
    . "Agregar nuevo</a></p></div>";
});

// Inicializamos los datos
add_action( "admin_init", function() {
	global $wpdb;
  $entrada = array(
    "tipo" => "tipo_de_entrada",
    "campo1" => "campo_a_comprobar",
    "campo2" => "campo_de_adjunto"
  );
	// Comprobamos el click en el botón, si no es así terminamos
	if (!isset($_GET["rj_nuevos"])) {return;}
	// Obtenemos los datos desde el CSV
	$posts = function() {
		$data = array();
		$errors = array();
		// Obtenemos la lista de archivos desde la carpeta data
		$files = glob( __DIR__ . "/data/*.csv" );
		foreach ( $files as $file ) {
			// Comprobamos los permisos, e intentamos leer el archivo
			if (!is_readable($file)) {chmod( $file, 0744 );}
			if (is_readable($file) && $_file = fopen($file,"r")) {
				$post = [];
				// Leemos las cabeceras en la primera línea, por ejemplo
        // titulo, contenido, adjunto
		    $header = fgetcsv($_file);
        // Obtenemos el resto de los datos del archivo
        while ( $row = fgetcsv($_file) ) {
          foreach ($header as $i => $key) {$post[$key] = $row[$i];}
          $data[] = $post;
		    }
				fclose( $_file );
			} else {
				$errors[] = "Error abriendo '$file'. Compruebe los permisos";
			}
		}
		if (!empty($errors)) {/* Procesamos los posibles errores */}
		return $data;
	};

	// Definimos una función para localizar duplicados
	$post_exists = function($valor) use ($wpdb, $entrada) {
    $consulta = $wpdb->prepare("SELECT ID "
    . "FROM {$table_name} WHERE {$entrada["campo1"]} = %s", $valor );
		$posts = $wpdb->get_col($consulta);
		return count($posts)>0;
	};

	foreach ( $posts() as $post ) {
		if ($post_exists($post["titulo"])) {
      // Procesamos las entradas duplicadas       
    } else {
      // Insertamos la nueva entrada en la base de datos
      $post["id"] = wp_insert_post( array(
        "post_title" => $post["titulo"],
        "post_content" => $post["contenido"],
        "post_type" => $entrada["tipo"],
        "post_status" => "publish"
      ));
      $uploads_dir = wp_upload_dir();
      // Procesamos el adjunto
      $adj = array();
      $adj["path"] = "{$uploads_dir["baseurl"]}/adjuntos/{$post["adjunto"]}";
      $adj["file"] = wp_check_filetype( $attachment["path"] );
      $adj["name"] = basename($adj["path"], ".{$adj["file"]["ext"]}" );
      $post["adjunto"] = $adj;
      // lo añadimos a la librería
      $post["adjunto"]["id"] = wp_insert_attachment( array(
        "guid" => $post["adjunto"]["path"],
        "post_mime_type" => $post["adjunto"]["file"]["type"],
        "post_title" => $post["adjunto"]["name"],
        "post_content" => "",
        "post_status" => "inherit"
      ));
      // y finalmente actualizamos la entrada
      update_field($entrada["campo2"], $post["adjunto"]["id"], $post["id"] );
    }
	}

});